//------------------------------------------------------------------------------
// File: client_splash.cs
// Author: Michael Felice
//------------------------------------------------------------------------------


$SplashScreenIndex = -1;
$SplashLoad = -1;
$SplashScreens = 0;
$DoneScreens = 0;
$ServerLoaded = false;
$ServerReady = false;
$ScriptLoaded = false;
$ServerStarted = false;

////////////////////////////////////////////////////////////////////////////////
//! Starts the splash screen and load process for the main menu
////////////////////////////////////////////////////////////////////////////////
function loadSplash()
{
   slgCreateThread("MMLoad", "slgMMLoadEntry", "slgMMLoadUpdate" , 100, true);

   // set up the splash screen sequence
   //$SplashScreens[0] = GameOptionsGui;
   //$SplashScreens[0] = optionsDlg;
   $SplashScreens[0] = StartupGui;
   $DoneScreens[0] = SplashPage;
   //$SplashScreens[1] = DistributorGui;
   $SplashScreens[1] = WW2Splash;
   $DoneScreens[1] = WW2Splash;
   $SplashLoad = 1;

   updateSplash();
   alxPlay(AudioSandlotJingle);
   
   setDetailLevel($pref::LevelOfDetail);
}

////////////////////////////////////////////////////////////////////////////////
//! Checks to see if the start
////////////////////////////////////////////////////////////////////////////////
function updateSplash()
{
   %screen = 0;
   %done = false;

   // get the current screen (or no screen if no screen has been loaded
   // yet) and find out if we need to move to the next screen.
   if ($SplashScreenIndex == -1)
   {
      %done = true;
   }
   // if the index is a valid index, then look up the screen that is
   // currently being used and find out if it is done or not
   else
   {
      %screen = $DoneScreens[$SplashScreenIndex];
      %done = %screen.done;
   }
   
   // if the screen is done being displayed, move to the next screen,
   // loading the new screen and initializing on that screen that it
   // is not done
   if (%done)
   {
      // if we are on the load screen, we need to make sure that the
      // XML has been fully loaded; otherwise, we will have trouble
      // loading AI datablocks
      if ($SplashLoad == $SplashScreenIndex + 1)
      {
         // if the xml is still loading, then interupt the
         // splash screen change until the loading is done
         if (isObject(MMLoad) == true && MMLoad.isAlive() == true)
         {
            schedule(100, 0, updateSplash);
            return;
         }
      }
      
      $SplashScreenIndex++;
      %screen = $DoneScreens[$SplashScreenIndex];
      
      // if the screen is valid, then update the current content
      if (%screen !$= "")
      {
         %screen.done = false;
         %screen = $SplashScreens[$SplashScreenIndex];
         Canvas.setContent(%screen);
      }
   }
   
   // if no screen is present, then we are done loading
   if (%screen $= "")
   {
      // before we can load the main menu, we will need to make sure
      // that the XML has completed loading (interupt the process in
      // this case)
      if (isObject(MMLoad) == true && MMLoad.isAlive() == true)
      {
         schedule(100, 0, updateSplash);
         return;
      }
      
      // now that the XML has been loaded, we need to check if the
      // datablocks have been loaded (this will happen if a load index
      // is incorrect or after the splash screens)
      if ($ServerStarted == false)
      {
         $SplashLoadEnd = MainMenuGui;
         loadServer();
      }
      // otherwise, we are done here-- splash screens are done, XML is
      // loaded, and the server has been loaded
      else if ($ServerReady == true)
      {
         return;
      }
   }

   // call the function again to check the splash progress
   schedule(100, 0, updateSplash);
}

function loadServer()
{
   if ($ServerStarted == false)
   {
      $ServerStarted = true;
      $LoadingGuiContent = "LoadingGui";
      onScriptLoad();
      
      %timer = new SLEndlessTimer(LoadServerTimer)
      {
         time = 0;
      };
      %timer.notifyOnFire(startServer);
   }
}

function startServer()
{
   // this should only be called once
   if($ServerLoaded)
   {
      createServer("SinglePlayer");
      %conn = new GameConnection(ServerConnection);
      RootGroup.add(ServerConnection);
      %conn.setConnectArgs($pref::Player::Name);
      %conn.setJoinPassword($Client::Password);
      %conn.connectLocal();
      //commandToServer('OnGameModeSelect', $WW2MODE_STORY);
      //commandToServer('OnHeroSelect', $WW2HERO_BANKER);
      LoadServerTimer.endTimer();
   }
   
   else
   {
      $ServerLoaded = loadNextScript();
   }
}

////////////////////////////////////////////////////////////////////////////////
//! This is the MainMenuLoad thread's entry method
////////////////////////////////////////////////////////////////////////////////
function slgMMLoadEntry()
{
   echo("*** MainMenuLoad thread started");
}

////////////////////////////////////////////////////////////////////////////////
//! This is the MainMenuLoad thread's update method
////////////////////////////////////////////////////////////////////////////////
function slgMMLoadUpdate()
{   
   // Load next xml file if not finished
   if(slgXMLLoadCount() != slgXMLLoadCurrent()) {
      slgLoadXML();
   }
   
   // We are finished with this thread
   else {
      // Load managers previously located in main.cc
      slgBuildExceptionHandler();
      
      // Destroy thread
      slgDestroyThread(MMLoad.getId());
   }
}